/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.mixin.mixins.common;

import com.aetherteam.aether.capability.accessory.MobAccessory;
import com.aetherteam.aether.event.hooks.EntityHooks;
import com.aetherteam.aether.mixin.AetherMixinHooks;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Mob.class})
public class MobMixin {
    @Inject(at={@At(value="HEAD")}, method={"canTakeItem(Lnet/minecraft/world/item/ItemStack;)Z"}, cancellable=true)
    private void canTakeItem(ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        ItemStack accessory;
        String identifier;
        Mob mob = (Mob)this;
        if (EntityHooks.canMobSpawnWithAccessories((Entity)mob) && !(identifier = AetherMixinHooks.getIdentifierForItem((LivingEntity)mob, stack)).isEmpty() && (accessory = AetherMixinHooks.getItemByIdentifier((LivingEntity)mob, identifier)).m_41619_() && mob.m_21531_()) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"equipItemIfPossible(Lnet/minecraft/world/item/ItemStack;)Lnet/minecraft/world/item/ItemStack;"}, cancellable=true)
    private void equipItemIfPossible(ItemStack stack, CallbackInfoReturnable<ItemStack> cir) {
        Mob mob = (Mob)this;
        MobAccessory.get(mob).ifPresent(accessoryMob -> {
            String identifier = AetherMixinHooks.getIdentifierForItem((LivingEntity)accessoryMob.getMob(), stack);
            if (!identifier.isEmpty()) {
                ItemStack accessory = AetherMixinHooks.getItemByIdentifier((LivingEntity)accessoryMob.getMob(), identifier);
                boolean flag = AetherMixinHooks.canReplaceCurrentAccessory(accessoryMob.getMob(), stack, accessory);
                if (flag && accessoryMob.getMob().m_7252_(stack)) {
                    double dropChance = accessoryMob.getEquipmentDropChance(identifier);
                    if (!accessory.m_41619_() && (double)Math.max(accessoryMob.getMob().m_217043_().m_188501_() - 0.1f, 0.0f) < dropChance) {
                        mob.m_19983_(accessory);
                    }
                    AetherMixinHooks.setItemByIdentifier((LivingEntity)mob, stack, identifier);
                    accessoryMob.setGuaranteedDrop(identifier);
                    mob.m_21530_();
                    cir.setReturnValue((Object)stack);
                }
            }
        });
    }
}

