/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.monster.dungeon;

import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.entity.monster.dungeon.AbstractValkyrie;
import com.aetherteam.aether.item.AetherItems;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class Valkyrie
extends AbstractValkyrie
implements NeutralMob {
    private static final int PERSISTENT_ANGER_TIME = Integer.MAX_VALUE;
    private int remainingPersistentAngerTime;
    @Nullable
    private UUID persistentAngerTarget;
    private int chatTimer;

    public Valkyrie(EntityType<? extends Valkyrie> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    public void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(3, (Goal)new AbstractValkyrie.LungeGoal(this, 0.65, 30));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, false, false, arg_0 -> ((Valkyrie)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(4, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    public static AttributeSupplier.Builder m_21552_() {
        return Valkyrie.createAttributes().m_22268_(Attributes.f_22278_, 0.25).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22276_, 50.0);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        double motionY = this.m_20184_().m_7098_();
        if (!this.m_20096_() && Math.abs(motionY - this.lastMotionY) > 0.07 && Math.abs(motionY - this.lastMotionY) < 0.09) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, 0.0225, 0.0));
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().m_5776_()) {
            this.m_21666_((ServerLevel)this.m_9236_(), true);
        }
    }

    public void m_8024_() {
        super.m_8024_();
        if (this.chatTimer > 0) {
            --this.chatTimer;
        }
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack item = player.m_21120_(hand);
        if (hand == InteractionHand.MAIN_HAND && this.m_5448_() == null) {
            this.m_21391_((Entity)player, 180.0f, 180.0f);
            if (!this.m_9236_().m_5776_() && this.chatTimer <= 0) {
                Object translationId = item.m_41720_() == AetherItems.VICTORY_MEDAL.get() ? (item.m_41613_() >= 10 ? "gui.aether.valkyrie.dialog.medal.1" : (item.m_41613_() >= 5 ? "gui.aether.valkyrie.dialog.medal.2" : "gui.aether.valkyrie.dialog.medal.3")) : "gui.aether.valkyrie.dialog." + (char)(this.m_217043_().m_188503_(3) + 49);
                this.chat(player, (Component)Component.m_237115_((String)translationId), false);
                this.m_5496_(this.getInteractSound(), 1.0f, this.m_6100_());
                this.chatTimer = 60;
            }
        }
        return InteractionResult.PASS;
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        Entity entity;
        boolean result = super.m_6469_(source, amount);
        if (!this.m_9236_().m_5776_() && (entity = source.m_7639_()) instanceof Player) {
            Player player = (Player)entity;
            if (this.m_5448_() == null && this.m_9236_().m_46791_() != Difficulty.PEACEFUL && this.m_21223_() > 0.0f) {
                this.chat(player, (Component)Component.m_237115_((String)("gui.aether.valkyrie.dialog.attack." + (char)(this.m_217043_().m_188503_(3) + 49))), false);
            }
        }
        return result;
    }

    public boolean m_7327_(Entity entity) {
        ServerPlayer player;
        boolean result = super.m_7327_(entity);
        if (entity instanceof ServerPlayer && (player = (ServerPlayer)entity).m_21223_() <= 0.0f) {
            this.chat((Player)player, (Component)Component.m_237110_((String)("gui.aether.valkyrie.dialog.playerdeath." + (char)(this.m_217043_().m_188503_(3) + 49)), (Object[])new Object[]{player.m_5446_()}), false);
        }
        return result;
    }

    public void m_6667_(DamageSource source) {
        Entity entity = source.m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.chat(player, (Component)Component.m_237115_((String)("gui.aether.valkyrie.dialog.defeated." + (char)(this.m_217043_().m_188503_(3) + 49))), false);
        }
        this.spawnExplosionParticles();
        super.m_6667_(source);
    }

    public void m_6825_() {
        this.m_7870_(Integer.MAX_VALUE);
    }

    public int m_6784_() {
        return this.remainingPersistentAngerTime;
    }

    public void m_7870_(int time) {
        this.remainingPersistentAngerTime = time;
    }

    @Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(@Nullable UUID target) {
        this.persistentAngerTarget = target;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)AetherSoundEvents.ENTITY_VALKYRIE_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)AetherSoundEvents.ENTITY_VALKYRIE_DEATH.get();
    }

    protected SoundEvent getInteractSound() {
        return (SoundEvent)AetherSoundEvents.ENTITY_VALKYRIE_INTERACT.get();
    }
}

