/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.gui.screen.perks;

import com.aetherteam.aether.client.gui.component.customization.ColorBox;
import com.aetherteam.aether.client.gui.component.customization.CustomizationButton;
import com.aetherteam.aether.client.gui.component.customization.DeveloperGlowColorBox;
import com.aetherteam.aether.client.gui.component.customization.DeveloperGlowCustomizationButton;
import com.aetherteam.aether.client.gui.component.customization.HaloColorBox;
import com.aetherteam.aether.client.gui.component.customization.HaloCustomizationButton;
import com.aetherteam.aether.network.AetherPacketHandler;
import com.aetherteam.aether.network.packet.serverbound.ServerDeveloperGlowPacket;
import com.aetherteam.aether.network.packet.serverbound.ServerHaloPacket;
import com.aetherteam.aether.perk.CustomizationsOptions;
import com.aetherteam.aether.perk.PerkUtil;
import com.aetherteam.aether.perk.types.DeveloperGlow;
import com.aetherteam.aether.perk.types.Halo;
import com.aetherteam.nitrogen.api.users.User;
import com.aetherteam.nitrogen.api.users.UserData;
import com.aetherteam.nitrogen.network.PacketRelay;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.simple.SimpleChannel;

public class AetherCustomizationsScreen
extends Screen {
    public static final ResourceLocation SAVE_BUTTON = new ResourceLocation("aether", "textures/gui/perks/customization/save_button.png");
    public static final ResourceLocation UNDO_BUTTON = new ResourceLocation("aether", "textures/gui/perks/customization/undo_button.png");
    private final Screen lastScreen;
    private final CustomizationsOptions customizations = CustomizationsOptions.INSTANCE;
    private Button haloToggleButton;
    private ColorBox haloColorBox;
    private Button developerGlowToggleButton;
    private ColorBox developerGlowColorBox;
    public boolean haloEnabled;
    public String haloColor;
    public boolean developerGlowEnabled;
    public String developerGlowColor;

    public AetherCustomizationsScreen(Screen lastScreen) {
        super((Component)Component.m_237115_((String)"gui.aether.customization.title"));
        this.lastScreen = lastScreen;
    }

    protected void m_7856_() {
        this.customizations.load();
        this.haloEnabled = this.customizations.isHaloEnabled();
        this.haloColor = this.customizations.getHaloHex();
        this.developerGlowEnabled = this.customizations.isDeveloperGlowEnabled();
        this.developerGlowColor = this.customizations.getDeveloperGlowHex();
        if (this.getMinecraft().f_91074_ != null) {
            User user = UserData.Client.getClientUser();
            boolean hasHalo = user != null && PerkUtil.hasHalo().test(user);
            boolean hasDeveloperGlow = user != null && PerkUtil.hasDeveloperGlow().test(user);
            int buttonCount = 0;
            if (hasHalo) {
                ++buttonCount;
            }
            if (hasDeveloperGlow) {
                ++buttonCount;
            }
            int xPos = this.f_96543_ / 2 - 65;
            int yPos = this.f_96544_ / 2 - 10 - (int)((double)buttonCount * 12.5);
            int i = 0;
            if (hasHalo) {
                this.setupHaloOptions(xPos, yPos, ++i);
            }
            if (hasDeveloperGlow) {
                this.setupDeveloperGlowOptions(xPos, yPos, ++i);
            }
        }
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, pressed -> this.m_7379_()).m_252987_(this.f_96543_ / 2 - 100, this.f_96544_ - 30, 200, 20).m_253136_());
    }

    private void setupHaloOptions(int xPos, int yPos, int i) {
        this.haloToggleButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)(this.haloEnabled ? "gui.aether.customization.halo.on" : "gui.aether.customization.halo.off")), pressed -> {
            this.haloEnabled = !this.haloEnabled;
            pressed.m_93666_((Component)Component.m_237115_((String)(this.haloEnabled ? "gui.aether.customization.halo.on" : "gui.aether.customization.halo.off")));
        }).m_252794_(xPos, yPos + 25 * i).m_253136_());
        this.haloColorBox = (ColorBox)this.m_142416_((GuiEventListener)new HaloColorBox(this, this.getMinecraft().f_91062_, xPos + 155, yPos + 25 * i, 60, 20, (Component)Component.m_237115_((String)"gui.aether.customization.halo.color")));
        if (this.haloColor != null && !this.haloColor.isEmpty()) {
            this.haloColorBox.m_94144_(this.haloColor);
        }
        MutableComponent undoText = Component.m_237115_((String)"gui.aether.customization.undo");
        HaloCustomizationButton undoButton = new HaloCustomizationButton(this, CustomizationButton.ButtonType.UNDO, this.haloColorBox, xPos + 220, yPos + 25 * i, 20, 20, 0, 20, 20, UNDO_BUTTON, 20, 60, pressed -> {
            if (pressed.m_142518_()) {
                this.haloEnabled = this.customizations.isHaloEnabled();
                this.haloColor = this.customizations.getHaloHex();
                this.haloToggleButton.m_93666_((Component)Component.m_237115_((String)(this.haloEnabled ? "gui.aether.customization.halo.on" : "gui.aether.customization.halo.off")));
                if (this.haloColor != null && !this.haloColor.isEmpty()) {
                    this.haloColorBox.m_94144_(this.haloColor);
                } else {
                    this.haloColorBox.m_94144_("");
                }
                this.customizations.load();
            }
        }, (Component)undoText);
        undoButton.m_257544_(Tooltip.m_257550_((Component)undoText));
        this.m_142416_((GuiEventListener)undoButton);
        MutableComponent saveText = Component.m_237115_((String)"gui.aether.customization.save");
        HaloCustomizationButton saveButton = new HaloCustomizationButton(this, CustomizationButton.ButtonType.SAVE, this.haloColorBox, xPos + 245, yPos + 25 * i, 20, 20, 0, 20, 20, SAVE_BUTTON, 20, 60, pressed -> {
            if (pressed.m_142518_()) {
                if (this.haloColorBox.hasValidColor() && this.haloColorBox.hasTextChanged()) {
                    this.customizations.setHaloColor(this.haloColorBox.m_94155_());
                    this.haloColor = this.customizations.getHaloHex();
                }
                if (this.haloEnabled != this.customizations.isHaloEnabled()) {
                    this.customizations.setIsHaloEnabled(this.haloEnabled);
                    this.haloEnabled = this.customizations.isHaloEnabled();
                }
                if (this.haloEnabled) {
                    if (this.getMinecraft().f_91074_ != null) {
                        PacketRelay.sendToServer((SimpleChannel)AetherPacketHandler.INSTANCE, (Object)new ServerHaloPacket.Apply(this.getMinecraft().f_91074_.m_20148_(), new Halo(this.haloColor)));
                    }
                } else if (this.getMinecraft().f_91074_ != null) {
                    PacketRelay.sendToServer((SimpleChannel)AetherPacketHandler.INSTANCE, (Object)new ServerHaloPacket.Remove(this.getMinecraft().f_91074_.m_20148_()));
                }
                this.customizations.save();
                this.customizations.load();
            }
        }, (Component)saveText);
        saveButton.m_257544_(Tooltip.m_257550_((Component)saveText));
        this.m_142416_((GuiEventListener)saveButton);
    }

    private void setupDeveloperGlowOptions(int xPos, int yPos, int i) {
        this.developerGlowToggleButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)(this.developerGlowEnabled ? "gui.aether.customization.developer_glow.on" : "gui.aether.customization.developer_glow.off")), pressed -> {
            this.developerGlowEnabled = !this.developerGlowEnabled;
            pressed.m_93666_((Component)Component.m_237115_((String)(this.developerGlowEnabled ? "gui.aether.customization.developer_glow.on" : "gui.aether.customization.developer_glow.off")));
        }).m_252794_(xPos, yPos + 25 * i).m_253136_());
        this.developerGlowColorBox = (ColorBox)this.m_142416_((GuiEventListener)new DeveloperGlowColorBox(this, this.getMinecraft().f_91062_, xPos + 155, yPos + 25 * i, 60, 20, (Component)Component.m_237115_((String)"gui.aether.customization.developer_glow.color")));
        if (this.developerGlowColor != null && !this.developerGlowColor.isEmpty()) {
            this.developerGlowColorBox.m_94144_(this.developerGlowColor);
        }
        MutableComponent undoText = Component.m_237115_((String)"gui.aether.customization.undo");
        DeveloperGlowCustomizationButton undoButton = new DeveloperGlowCustomizationButton(this, CustomizationButton.ButtonType.UNDO, this.developerGlowColorBox, xPos + 220, yPos + 25 * i, 20, 20, 0, 20, 20, UNDO_BUTTON, 20, 60, pressed -> {
            if (pressed.m_142518_()) {
                this.developerGlowEnabled = this.customizations.isDeveloperGlowEnabled();
                this.developerGlowColor = this.customizations.getDeveloperGlowHex();
                this.developerGlowToggleButton.m_93666_((Component)Component.m_237115_((String)(this.developerGlowEnabled ? "gui.aether.customization.developer_glow.on" : "gui.aether.customization.developer_glow.off")));
                if (this.developerGlowColor != null && !this.developerGlowColor.isEmpty()) {
                    this.developerGlowColorBox.m_94144_(this.developerGlowColor);
                } else {
                    this.developerGlowColorBox.m_94144_("");
                }
                this.customizations.load();
            }
        }, (Component)undoText);
        undoButton.m_257544_(Tooltip.m_257550_((Component)undoText));
        this.m_142416_((GuiEventListener)undoButton);
        MutableComponent saveText = Component.m_237115_((String)"gui.aether.customization.save");
        DeveloperGlowCustomizationButton saveButton = new DeveloperGlowCustomizationButton(this, CustomizationButton.ButtonType.SAVE, this.developerGlowColorBox, xPos + 245, yPos + 25 * i, 20, 20, 0, 20, 20, SAVE_BUTTON, 20, 60, pressed -> {
            if (pressed.m_142518_()) {
                if (this.developerGlowColorBox.hasValidColor() && this.developerGlowColorBox.hasTextChanged()) {
                    this.customizations.setDeveloperGlowColor(this.developerGlowColorBox.m_94155_());
                    this.developerGlowColor = this.customizations.getDeveloperGlowHex();
                }
                if (this.developerGlowEnabled != this.customizations.isDeveloperGlowEnabled()) {
                    this.customizations.setIsDeveloperGlowEnabled(this.developerGlowEnabled);
                    this.developerGlowEnabled = this.customizations.isDeveloperGlowEnabled();
                }
                if (this.developerGlowEnabled) {
                    if (this.getMinecraft().f_91074_ != null) {
                        PacketRelay.sendToServer((SimpleChannel)AetherPacketHandler.INSTANCE, (Object)new ServerDeveloperGlowPacket.Apply(this.getMinecraft().f_91074_.m_20148_(), new DeveloperGlow(this.developerGlowColor)));
                    }
                } else if (this.getMinecraft().f_91074_ != null) {
                    PacketRelay.sendToServer((SimpleChannel)AetherPacketHandler.INSTANCE, (Object)new ServerDeveloperGlowPacket.Remove(this.getMinecraft().f_91074_.m_20148_()));
                }
                this.customizations.save();
                this.customizations.load();
            }
        }, (Component)saveText);
        saveButton.m_257544_(Tooltip.m_257550_((Component)saveText));
        this.m_142416_((GuiEventListener)saveButton);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        guiGraphics.m_280653_(this.f_96547_, this.m_96636_(), this.f_96543_ / 2, 15, 0xFFFFFF);
        guiGraphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"gui.aether.customization.color"), this.f_96543_ / 2 - 65 + 184, this.f_96544_ / 2 - 10 - 14, 0xFFFFFF);
        if (this.getMinecraft().f_91074_ != null) {
            int x = this.f_96543_ / 2 - 175;
            int y = this.f_96544_ / 2 + 50;
            InventoryScreen.m_274545_((GuiGraphics)guiGraphics, (int)(x + 33), (int)y, (int)60, (float)(x + 33 - mouseX), (float)(y - 100 - mouseY), (LivingEntity)this.getMinecraft().f_91074_);
        }
        if (this.haloColorBox != null && !this.haloColorBox.m_94155_().equals(this.haloColor)) {
            if (this.haloColorBox.m_94155_().length() == 6 && this.haloColorBox.hasValidColor()) {
                this.haloColor = this.haloColorBox.m_94155_();
            } else if (!this.haloColor.isEmpty()) {
                this.haloColor = "";
            }
        }
        if (this.developerGlowColorBox != null && !this.developerGlowColorBox.m_94155_().equals(this.developerGlowColor)) {
            if (this.developerGlowColorBox.m_94155_().length() == 6 && this.developerGlowColorBox.hasValidColor()) {
                this.developerGlowColor = this.developerGlowColorBox.m_94155_();
            } else if (!this.developerGlowColor.isEmpty()) {
                this.developerGlowColor = "";
            }
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public void m_7379_() {
        this.getMinecraft().m_91152_(this.lastScreen);
    }
}

